//Dodana funkcja rejestrujaca
unit DiskInfo;

interface

uses
  Windows, SysUtils, Classes, Controls, StdCtrls, ExtCtrls, ComCtrls;

//Stale
const DI_MAX_NAMELENGTH=255; //niepotrzebne, bo array of Char -> String

//Struktura przechowujaca informacje o dysku
type
    CString = array[0..DI_MAX_NAMELENGTH] of Char;
    _disk_info = record
        disk_letter :Char;
        disk_accesible :Boolean;

        disk_type :Integer;
        disk_type_str :CString;

        total_kb :DWord;
        free_kb :DWord;

        free_fraction :Double;
        free_percentage :DWord;

        volume_name :CString;
        volume_SN :DWord;
        FAT_name :CString;
        max_filedir_name :DWord;

        max_path :DWord;
    end;

//Deklaracja klasy
TDiskInfoPanel=class(TCustomPanel)//tak naprawde to dziedziczy w Delphi z TObject tj. "TDiskInfo = class of TObject"(stad obecna jest destruktor Destroy i metoda Free)
private
    ADriveLetter :Char;
    ProgressBar :TProgressBar;
    LewyOpis :TLabel;
    PrawyOpis :TLabel;

    function GetDiskInfo(drvletter :Char) :Boolean;
    procedure SetDriveLetter(drvletter :Char);
public
    Values :_disk_info;
    constructor Create(AOwner :TComponent); override;
published
    property DriveLetter :Char read ADriveLetter write SetDriveLetter;
end;

procedure Register; //ta procedura obsluguje rejestrowanie komponentow

implementation

function TDiskInfoPanel.GetDiskInfo(drvletter :Char) :Boolean;
var
   drvrootstr :String;
   TotalBytes,FreeBytes :TLargeInteger; //ULARGE_INTEGER, to w Delphi6 nie sa unie tylko liczby Int64
   disk_info :_disk_info;
begin
//Ustalanie wstepnych wartosci
//W calej funkcji korzysta sie z tego with
with disk_info do begin

disk_letter:=UpCase(drvletter);
disk_accesible:=True;

disk_type:=0;
disk_type_str:=''; //Jezeli bylaby tablica znakow to nalezaloby korzystac z StrCopy()
total_kb:=0;
free_kb:=0;
free_percentage:=0;
volume_name:='';
volume_SN:=0;
FAT_name:='';
max_filedir_name:=0;
max_path:=0;

//Sciezka katalogu glownego na dysku
drvrootstr:=disk_letter+':\';

//Typ napedu (drive type)
disk_type:=GetDriveType(PChar(drvrootstr));
case (disk_type) of
    0:
      begin
      disk_type_str:='Napd nie istnieje';
      disk_accesible:=False;
      end;
    1:
      begin
      disk_type_str:='Dysk nie jest sformatowany';
      disk_accesible:=False;
      end;
    DRIVE_REMOVABLE: disk_type_str:='Dysk wymienny';
    DRIVE_FIXED: disk_type_str:='Dysk lokalny';
    DRIVE_REMOTE: disk_type_str:='Dysk sieciowy';
    DRIVE_CDROM: disk_type_str:='Pyta CDROM';
    DRIVE_RAMDISK: disk_type_str:='RAM Drive';
    else
    disk_type_str:='Typ dysku nierozpoznany';
    end;

//Jezeli dysk niedostepny, to konczymy
if (not disk_accesible) then
   begin
   GetDiskInfo:=false;
   Values:=disk_info;
   Exit;
   end;

//Ilosc wolnego miejsca na dysku (disk free space)
Result:=GetDiskFreeSpaceEx(PChar(drvrootstr),TLargeInteger(nil^),TotalBytes,@FreeBytes);
total_kb:=TotalBytes div 1024;
free_kb:=FreeBytes div 1024;

if ((Result) and (total_kb<>0)) then
	begin
        free_fraction:=free_kb/total_kb;
        free_percentage:=Round(100*free_fraction);
        end
        else
        begin
        disk_info.free_fraction:=0;
        disk_info.free_percentage:=0;
        disk_info.disk_accesible:=False;
        Result:=False;
        Values:=disk_info;
        Exit;
        end;

//Dookreslanie rodzaju dysku wymiennego
if (disk_type=DRIVE_REMOVABLE) then
	begin
	if (total_kb<=(500000/1024.0)) then disk_type_str:='Dyskietka DD 5.25"';
	if (total_kb> (500000/1024.0)) then disk_type_str:='Dyskietka DD 3.5"';
	if (total_kb> (1000000/1024.0)) then disk_type_str:='Dyskietka HD 5.25"';
	if (total_kb> (1300000/1024.0)) then disk_type_str:='Dyskietka HD 3.5"';
	if (total_kb> (3000000/1024.0)) then disk_type_str:='Dysk wymienny (kiesze)'; //w zasadzie mozna tak oznaczyc kazdy dysk
        end;

//Nazwa dysku, typ FAT, numer seryjny (GetVolumeInformation)
//Niezgodnie z Win32 SDK parametr max_filedir_name nie jest wskaznikiem

{
//Plik Source\Rtl\Win\Windows.pas
function GetVolumeInformation(lpRootPathName: PChar;
                              lpVolumeNameBuffer: PChar;
                              nVolumeNameSize: DWORD;
                              lpVolumeSerialNumber: PDWORD;
                              var lpMaximumComponentLength,
                              lpFileSystemFlags: DWORD;
                              lpFileSystemNameBuffer: PChar;
                              nFileSystemNameSize: DWORD): BOOL; stdcall;
}

GetDiskInfo:=GetVolumeInformation(
        PChar(drvrootstr),
        @volume_name,
        SizeOf(disk_info.volume_name),
        @volume_SN,
        max_filedir_name,
        DWord(nil^),
        @FAT_name,
        SizeOf(FAT_name));

max_path:=MAX_PATH;
Values:=disk_info;
end; //koniec od with disk_info
end; //koniec GetDiskInfo


constructor TDiskInfoPanel.Create(AOwner :TComponent);
begin
inherited Create(AOwner); //podobnie jak :TCustomPanel(AOwner) w C++

Caption:='';
BevelInner:=bvNone;
BevelOuter:=bvNone;
Width:=640-30;

ProgressBar:=TProgressBar.Create(Self);
ProgressBar.Height:=Height div 2;
ProgressBar.Width:=Width;
ProgressBar.Left:=0;
ProgressBar.Top:=Height div 2;
ProgressBar.Parent:=Self;

LewyOpis:=TLabel.Create(Self);
LewyOpis.Left:=0;
LewyOpis.Top:=0;
LewyOpis.Parent:=Self;

PrawyOpis:=TLabel.Create(Self);
PrawyOpis.Left:=0; //tymczasowo
PrawyOpis.Top:=0;
PrawyOpis.Parent:=Self;

DriveLetter:='C';
end;

procedure TDiskInfoPanel.SetDriveLetter(drvletter :Char);
begin
ADriveLetter:=drvletter;
if ADriveLetter in ['a'..'z'] then Dec(ADriveLetter,32);
GetDiskInfo(drvletter);

ProgressBar.Position:=100-Values.free_percentage;
LewyOpis.Caption:=DriveLetter+':   '+Values.volume_name+'   ('+Values.FAT_name+')';
PrawyOpis.Caption:=IntToStr((Values.total_kb-Values.free_kb) div 1024)+'MB / '+IntToStr(Values.total_kb div 1024)+'MB  ('+IntToStr(100-Values.free_percentage)+'%)';
PrawyOpis.Left:=ProgressBar.Left+ProgressBar.Width-PrawyOpis.Width;
end;

//------------------------------------------------------

//Rejestracja komponentu
procedure Register;
begin
RegisterComponents('JM', [TDiskInfoPanel]);
end;

end.
